# Using linear regression to model non-linear relationships

time <- c(3, 6, 9, 12, 15, 18) # This is the predictor (independent variable)
error <- c(6.3, 3.9, 2.3, 2.0, 2.8, 1.6) # This is the outcome (dependent variable)

# Create a plot of 1x3 to plot three graphs
par(mfrow=c(1,3), mar = c(4,4,1,1), pty='s', cex.main = 1.1)

# Power law model
model.1 <- lm(log(error) ~ log(time))
b0 <- model.1$coefficients[1]
b1 <- model.1$coefficients[2]
R2.adj <-  round(summary(model.1)$adj.r.squared, digits=3)
plot(time, error, main = "ln(Y) = b0 + b1*ln(X)")
curve(exp(b0+b1*log(x)), add = TRUE, col="red")
text(12, 4, paste("adj. R squared =", R2.adj))

# Exponential model
model.2 <- lm(log(error) ~ time)
b0 <- model.2$coefficients[1]
b1 <- model.2$coefficients[2]
R2.adj <-  round(summary(model.2)$adj.r.squared, digits=3)
plot(time, error, main = "ln(Y) = b0 + b1*X")
curve(exp(b0+b1*x), add = TRUE, col="red")
text(12, 4, paste("adj. R squared =", R2.adj))

# Logarithmic model
model.3 <- lm(error ~ log(time))
b0 <- model.3$coefficients[1]
b1 <- model.3$coefficients[2]
R2.adj <-  round(summary(model.3)$adj.r.squared, digits=3)
plot(time, error, main = "Y = b0 + b1*ln(X)")
curve(b0+b1*log(x), add = TRUE, col="red")
text(12, 4, paste("adj. R squared =", R2.adj))
